@extends('admin.master')
@section('title')
    Job Circular list
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3>Job Circular Information</h3>
                        <a href="{{ route('jobcircular.trash') }}" class="btn btn-warning"><i class="fa-solid fa-trash-can-arrow-up fa-fw"></i> View Trash</a>
                    </div>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('jobcircular.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="department_id" class="form-label mb-2">Select Department <span class="text-danger">*</span></label>
                                    <select id="defaultSelect" name="department_id"
                                        class="form-select
                                    @error('department_id')
                                        is-invalid
                                    @enderror">
                                        <option selected>Choose a Department</option>
                                        @forelse ($departments as $department)
                                            <option value="{{ $department->id }}">{{ $department->company_department_name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                    @error('department_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="company_id" class="form-label mb-2">Select Comapny <span class="text-danger">*</span></label>
                                    <select id="defaultSelect" name="company_id"
                                        class="form-select
                                    @error('company_id')
                                        is-invalid
                                    @enderror">
                                        <option selected>Choose a Comapny</option>
                                        @forelse ($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->company_name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                    @error('company_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="producttype_id" class="form-label mb-2">Select Product Type <span class="text-danger">*</span></label>
                                    <select id="defaultSelect" name="producttype_id"
                                        class="form-select
                                    @error('producttype_id')
                                        is-invalid
                                    @enderror">
                                        <option selected>Choose a Product</option>
                                        @forelse ($producttypes as $producttype)
                                            <option value="{{ $producttype->id }}">{{ $producttype->product_name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                    @error('producttype_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="job_title" class="form-label mb-2">Job Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('job_title')
                                    is-invalid
                                    @enderror" rows="5" name="job_title" value="{{ old('job_title') }}" id="job_title">
                                    @error('job_title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="company_nam" class="form-label mb-2">Company Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('company_nam')
                                    is-invalid
                                    @enderror" rows="5" name="company_nam" value="{{ old('company_nam') }}" id="company_nam">
                                    @error('company_nam')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="vacancy" class="form-label mb-2">Vacancy <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control @error('vacancy')
                                    is-invalid
                                    @enderror" rows="5" name="vacancy" value="{{ old('vacancy') }}" id="vacancy">
                                    @error('vacancy')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="job_banner" class="form-label mb-2">Job Thumbnail</label>
                                    <input type="file" class="form-control @error('job_banner')
                                    is-invalid
                                    @enderror" rows="5" name="job_banner" value="{{ old('job_banner') }}" id="job_banner">
                                    @error('job_banner')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="responsibilities" class="form-label mb-2">Responsibilities</label>
                                    <textarea id="tinymce" class="editor form-control @error('responsibilities')
                                    is-invalid
                                    @enderror" col="10" row="3" name="responsibilities" >{{ old('responsibilities') }}</textarea>
                                </div>
                                @error('responsibilities')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="experience" class="form-label mb-2">Experience <span class="text-danger">*</span></label>
                                    <textarea id="tinymce" class="editor form-control @error('experience')
                                    is-invalid
                                    @enderror" col="10" row="3" name="experience" >{{ old('experience') }}</textarea>
                                </div>
                                @error('experience')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="location" class="form-label mb-2">Location <span class="text-danger">*</span></label>
                                    <textarea id="tinymce" class="editor form-control @error('location')
                                    is-invalid
                                    @enderror" col="10" row="3" name="location" >{{ old('location') }}</textarea>
                                </div>
                                @error('location')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="qualification" class="form-label mb-2">Qualification</label>
                                    <input type="text" class="form-control @error('qualification')
                                    is-invalid
                                    @enderror" rows="5" name="qualification" value="{{ old('qualification') }}" id="qualification">
                                    @error('qualification')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="salary_range" class="form-label mb-2">Salary Range</label>
                                    <input type="text" class="form-control @error('salary_range')
                                    is-invalid
                                    @enderror" rows="5" name="salary_range" value="{{ old('salary_range') }}" id="salary_range">
                                    @error('salary_range')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="others_facilities" class="form-label mb-2">Others Facilities</label>
                                    <input type="text" class="form-control @error('others_facilities')
                                    is-invalid
                                    @enderror" rows="5" name="others_facilities" value="{{ old('others_facilities') }}" id="others_facilities">
                                    @error('others_facilities')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="deadline_till" class="form-label mb-2">Dead Line</label>
                                    <input type="date" class="form-control @error('deadline_till')
                                    is-invalid
                                    @enderror" rows="5" name="deadline_till" value="{{ old('deadline_till') }}">
                                    @error('deadline_till')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="company_logo" class="form-label mb-2">Company Logo</label>
                                    <input type="file" class="form-control @error('company_logo')
                                    is-invalid
                                    @enderror" rows="5" name="company_logo" value="{{ old('company_logo') }}" id="company_logo">
                                    @error('company_logo')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="table-responsive">
                                <button type="submit" class="btn btn-info">Submit</button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>Last Updated</th>
                        <th>Publisher</th>
                        <th>Logo</th>
                        <th>Company</th>
                        <th>Company Type</th>
                        <th>Department</th>
                        <th>Product Type</th>
                        <th>Job Title</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                        @forelse ($jobcirculars as $jobcircular)
                        <tr>
                            <td>
                                <strong>{{ $jobcirculars->firstItem() + $loop->index }}</strong>
                            </td>
                            <td>{{ $jobcircular->updated_at->format('d-M-Y') }}</td>
                            <td>{{ $jobcircular->user->name }}</td>
                            <td class="text-center">
                                <img src="{{ asset('jobcircular') }}/{{ $jobcircular->company_logo }}"
                                class="rounded-circle" alt="" style="width:30px; height:30px;">
                            </td>
                            <td>{{ $jobcircular->company_nam }}</td>
                            <td>{{ $jobcircular->company->company_name }}</td>
                            <td>{{ $jobcircular->department->company_department_name }}</td>
                            <td>{{ $jobcircular->productType->product_name }}</td>
                            <td>{{ $jobcircular->job_title }}</td>
                            <td class="text-center">
                                <div class="action-btns d-flex align-items-center">
                                    <div>
                                        <a href="{{ route('jobcircular.show', $jobcircular->id) }}"
                                            class="text-success me-2" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="View">
                                            <i class="fa-solid fa-eye"></i>
                                        </a>
                                    </div>
                                    <div>
                                        <a href="{{ route('jobcircular.edit', $jobcircular->id) }}"
                                            class="text-info" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Edit"><i class="fa-solid fa-pen-to-square fa-fw"></i>
                                        </a>
                                    </div>
                                    <div>
                                        <form action="{{ route('jobcircular.destroy', $jobcircular->id) }}"
                                            method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-warning btn_custom show_confirm" data-toggle="tooltip"
                                            data-placement="top" data-bs-original-title="Delete">
                                                <i class="fa-solid fa-trash-can fa-fw"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                    @endforelse

                    </tbody>

                </table>
            </div>
        </div>
    </div>
@endsection
@push('admin_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.1.1/tinymce.min.js" referrerpolicy="origin"></script>
<script type="text/javascript">
    tinymce.init({
        selector: 'textarea#default'
    });
</script>
    @include('admin.common.script')
@endpush
