@extends('admin.master')
@section('title')
    Job Circular Edit
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush
@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3>Job Circular Update</h3>
                        <a href="{{ route('jobcircular.index') }}" class="btn btn-info"><i class="fa-solid fa-angles-left fa-fw"></i> Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('jobcircular.update', $jobcircular->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="department_id" class="form-label mb-2">Select Department</label>
                                    <select id="defaultSelect" name="department_id"
                                        class="form-select
                                    @error('department_id')
                                        is-invalid
                                    @enderror">
                                        @forelse ($departments as $department)
                                            <option value="{{ $department->id }}" @if ($department->id == $jobcircular->department_id)
                                                selected
                                            @endif>{{ $department->company_department_name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                    @error('department_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="company_id" class="form-label mb-2">Select Comapny</label>
                                    <select id="defaultSelect" name="company_id"
                                        class="form-select
                                    @error('company_id')
                                        is-invalid
                                    @enderror">
                                        @forelse ($companies as $company)
                                            <option value="{{ $company->id }}" @if ($company->id == $jobcircular->company_id)
                                                selected
                                            @endif>{{ $company->company_name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                    @error('company_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="producttype_id" class="form-label mb-2">Select Product Type</label>
                                    <select id="defaultSelect" name="producttype_id"
                                        class="form-select
                                    @error('producttype_id')
                                        is-invalid
                                    @enderror">
                                        @forelse ($producttypes as $producttype)
                                            <option value="{{ $producttype->id }}" @if ($producttype->id == $jobcircular->producttype_id)
                                                selected
                                            @endif>{{ $producttype->product_name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                    @error('producttype_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="job_title" class="form-label mb-2">Job Title</label>
                                    <input type="text" class="form-control @error('job_title')
                                    is-invalid
                                    @enderror" rows="5" name="job_title" value="{{ $jobcircular->job_title }}" id="job_title">
                                    @error('job_title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="company_nam" class="form-label mb-2">Company Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('company_nam')
                                    is-invalid
                                    @enderror" rows="5" name="company_nam" value="{{ $jobcircular->company_nam }}" id="company_nam">
                                    @error('company_nam')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="vacancy" class="form-label mb-2">Vacancy</label>
                                    <input type="number" class="form-control @error('vacancy')
                                    is-invalid
                                    @enderror" rows="5" name="vacancy" value="{{ $jobcircular->vacancy }}" id="vacancy">
                                    @error('vacancy')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="job_banner" class="form-label mb-2">Job Thumbnail</label>
                                    <input type="file" class="form-control @error('job_banner')
                                    is-invalid
                                    @enderror" rows="5" name="job_banner" value="{{ old('job_banner') }}" id="job_banner">
                                    @error('job_banner')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div>
                                    <img src="{{ asset('jobcircular') }}/{{ $jobcircular->job_banner }}"
                                    class="" alt="" style="width:100px; height:100px;">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="responsibilities" class="form-label mb-2">Responsibilities</label>
                                    <textarea id="tinymce" class="editor form-control @error('responsibilities')
                                    is-invalid
                                    @enderror" col="10" row="3" name="responsibilities" >{!! $jobcircular->responsibilities !!}</textarea>
                                </div>
                                @error('responsibilities')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="experience" class="form-label mb-2">Experience</label>
                                    <textarea id="tinymce" class="editor form-control @error('experience')
                                    is-invalid
                                    @enderror" col="10" row="3" name="experience" >{!! $jobcircular->experience !!}</textarea>
                                </div>
                                @error('experience')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="location" class="form-label mb-2">Location</label>
                                    <textarea id="tinymce" class="editor form-control @error('location')
                                    is-invalid
                                    @enderror" col="10" row="3" name="location" >{!! $jobcircular->location !!}</textarea>
                                </div>
                                @error('location')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="qualification" class="form-label mb-2">Qualification</label>
                                    <input type="text" class="form-control @error('qualification')
                                    is-invalid
                                    @enderror" rows="5" name="qualification" value="{{ $jobcircular->qualification }}" id="qualification">
                                    @error('qualification')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="salary_range" class="form-label mb-2">Salary Range</label>
                                    <input type="text" class="form-control @error('salary_range')
                                    is-invalid
                                    @enderror" rows="5" name="salary_range" value="{{ $jobcircular->salary_range }}" id="salary_range">
                                    @error('salary_range')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="others_facilities" class="form-label mb-2">Others Facilities</label>
                                    <input type="text" class="form-control @error('others_facilities')
                                    is-invalid
                                    @enderror" rows="5" name="others_facilities" value="{{ $jobcircular->others_facilities }}" id="others_facilities">
                                    @error('others_facilities')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="deadline_till" class="form-label mb-2">Dead Line</label>
                                    <input type="date" class="form-control @error('deadline_till')
                                    is-invalid
                                    @enderror" rows="5" name="deadline_till" value="{{ $jobcircular->deadline_till }}" id="deadline_till">
                                    @error('deadline_till')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12 mb-3">
                                <div class="form-group mb-3">
                                    <label for="company_logo" class="form-label mb-2">Company Logo</label>
                                    <input type="file" class="form-control @error('company_logo')
                                    is-invalid
                                    @enderror" rows="5" name="company_logo" value="" id="company_logo">
                                    @error('company_logo')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div>
                                    <img src="{{ asset('jobcircular') }}/{{ $jobcircular->company_logo }}"
                                    class="" alt="" style="width:100px; height:100px;">
                                </div>
                            </div>
                            <div class="table-responsive">
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('admin_script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.1.1/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
    </script>
@include('admin.common.script')
@endpush
