@extends('admin.master')
@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">

                @if(session('message'))
                    <div class="alert alert-success" role="alert">
                        {{session('message')}}
                    </div>
                @endif
                <div class="card-body">
                    <form class="form-horizontal" action="{{route('update.video.gallery')}}" enctype="multipart/form-data" method="POST">
                        @csrf

                        <input type="hidden" value="{{$gallery->id}}" name="id">
                        <div class="form-group">
                            <label>Video</label>
                            <textarea class="editor form-control" col="10" row="3" name="video_link" >{{$gallery->video_link}}</textarea>
                        </div>

                        <div class="form-group">
                            <label> Image</label>
                            <input type="file" name="video_image" class="form-control">
                            <img src="{{asset($gallery->video_image??null)}}" width="100" height="100" alt="">
                        </div>

                        <div class="form-group">
                            <label>Active/Deactive</label>
                            <select class="form-control" name="status">
                                <option value="1" @if ($gallery->status == 1) selected @endif>Active</option>
                                <option value="0" @if ($gallery->status == 0) selected @endif>Deactive</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Display What?</label>
                            <select class="form-control" name="display_what">
                                <option value="1" @if ($gallery->display_what == 1) selected @endif>Video</option>
                                <option value="0" @if ($gallery->display_what == 0) selected @endif>Image</option>
                            </select>
                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('admin_script')

@include('admin.common.script')
@endpush