@extends('admin.master')
@section('title')
    Company Department Edit
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush

@section('body')
    <div class="row mt-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('companydepartment.update', $department->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <h3>Company Department Update</h3>
                        <div class="form-group">
                            <label for="company_department_name">Deaprtment Name</label>
                            <input type="text" name="company_department_name" class="form-control @error('company_department_name')
                            is-invalid
                        @enderror" value="{{ $department->company_department_name }}">
                            @error('company_department_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" name="is_active" type="checkbox" role="switch" id="activeStatus" @if ($department->is_active == 1)
                            checked
                        @endif>
                            <label class="form-check-label" for="activeStatus">Active/Inactive</label>
                        </div>
                        <div class="table-responsive">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('admin_script')
@include('admin.common.script')
@endpush
