@extends('admin.master')
@section('title')
    Job Applicants Info
@endsection

@push('admin_style')
@include('admin.common.style')
@endpush

@section('body')
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <table id="config-table" class="table display table-striped border no-wrap">
                    <thead>
                    <tr>
                        <th>List</th>
                        <th>Last Updated</th>
                        <th>Department</th>
                        <th>Profile</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach ($reapplies as $key => $apply)
                        <tr>
                            <td>{{ ++$key }}</td>
                            <td>{{ $apply->updated_at->format('d-M-Y') }}</td>
                            <td>{{ $apply->reJobCircular->department->company_department_name }}</td>
                            <td>
                                @if ($apply->user->profile->profileImage??null)
                                <div class="avatar-container">
                                    <img alt="avatar"
                                        src="{{ asset($apply->user->profile->profileImage->profile_image??null) }}"
                                        class="rounded-circle" style="width:30px; height: 30px">
                                </div>
                                @else
                                <div class="avatar-container">
                                    <img alt="avatar" src="{{ asset('profile/default_profile.png') }}"
                                    class="rounded-circle" style="width:30px; height: 30px">
                                </div>
                                @endif
                            </td>
                            <td>{{ $apply->user->name }}</td>
                            <td>{{ $apply->user->email }}</td>
                            <td>
                                @if ($apply->is_active == 1)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-warning">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div>
                                        <a href="{{ route('reapply.view', ['id' => $apply->id]) }}"
                                            class="action-btn bs-tooltip me-2" data-toggle="tooltip"
                                            data-placement="top" title="" data-bs-original-title="View">
                                            <i class="fa-solid fa-eye text-success"></i>
                                        </a>
                                    </div>
                                    {{-- <div>
                                        <a href="{{ route('apply.edit', $apply->id) }}"
                                            class="action-btn bs-tooltip me-1" data-toggle="tooltip"
                                            data-placement="top" title="" data-bs-original-title="Edit">
                                            <i class="fa-regular fa-pen-to-square text-info"></i>
                                        </a>
                                    </div> --}}
                                    {{-- <div>
                                        <form action="{{ route('apply.destroy', $apply->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit"
                                                class="action-btn bs-tooltip btn_custom show_confirm"
                                                data-toggle="tooltip" data-placement="top" title=""
                                                data-bs-original-title="Delete"><i
                                                    class="fa-solid fa-trash-can text-warning"></i></button>
                                        </form>
                                    </div> --}}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#default'
        });
    </script>
@endsection

@push('admin_script')
@include('admin.common.script')
@endpush
