<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCareersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('careers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('designation');
            $table->string('university');
            $table->string('company_name');
            $table->longText('career_summery');
            $table->longText('skills');
            $table->longText('experience');
            $table->longText('education');
            $table->longText('extra_cariculam');
            $table->longText('language');
            $table->longText('professional_training');
            $table->longText('reference');
            $table->longText('declaration');
            $table->string('office_idcard');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('careers');
    }
}
