<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJobCircularsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('job_circulars', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('department_id')->constrained('company_departments')->onDelete('cascade');
            $table->foreignId('company_id')->constrained('companies')->onDelete('cascade');
            $table->foreignId('producttype_id')->constrained('product_types')->onDelete('cascade');
            $table->string('company_nam');
            $table->integer('vacancy');
            $table->string('job_title');
            $table->longText('responsibilities')->nullable();
            $table->longText('experience');
            $table->string('qualification')->nullable();
            $table->longText('location');
            $table->string('salary_range')->nullable();
            $table->string('others_facilities')->nullable();
            $table->string('job_banner')->nullable();
            $table->string('company_logo')->nullable();
            $table->date('deadline_till');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('job_circulars');
    }
}
