<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VideoGallery extends Model
{
    use HasFactory;
    public static $data,$image,$imageName,$directory,$imageUrl;

    public static function save_gallery($request)
    {
        self::$data = new VideoGallery();
        self::$data->video_link = $request->video_link??null;
        if ($request->file('video_image')) {
            if (self::$data->video_image) {
                if (file_exists(self::$data->video_image)) {
                    unlink(self::$data->video_image);
                    self::$data->video_image = self::saveImage($request);
                }
            } else {
                self::$data->video_image = self::saveImage($request);
            }
        }
        self::$data->save();
    }
    public static function update_gallery($request)
    {
        self::$data = VideoGallery::find($request->id);
        self::$data->video_link = $request->video_link??null;
        self::$data->status = $request->status??null;
        self::$data->display_what = $request->display_what??null;
        if ($request->file('video_image')) {
            if (self::$data->video_image) {
                if (file_exists(self::$data->video_image)) {
                    unlink(self::$data->video_image);
                    self::$data->video_image = self::saveImage($request);
                }
            } else {
                self::$data->video_image = self::saveImage($request);
            }
        }
        self::$data->save();
    }

    private static function saveImage($request){
        self::$image = $request->file('video_image');
        self::$imageName = 'gallery_video_image-'.rand().'.'. self::$image->Extension();
        self::$directory = 'gallery/';
        self::$imageUrl = self::$directory.self::$imageName;
        self::$image->move(self::$directory,self::$imageName);
        return self::$imageUrl;
    }
}
