<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = ['id'];

    //Relationship with User
    public function users()
    {
        return $this->hasMany(User::class);
    }

    //Relationship with Permission
    public function permissions()
    {
        return $this->belongsToMany(Permission::class);
    }
}
