<?php

namespace App\Models;

use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Recruiter extends Authenticatable
{
    use HasFactory, Notifiable, SoftDeletes;
    public static $data,$image, $imageName, $imageDirectory, $imageUrl;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    // protected $fillable = [
    //     'name', 'email', 'password', 'is_admin'
    // ];

    protected $guarded = ['id'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public static function update_recruiterInfo($request)
    {
        // dd($request->all());

        self::$data = Recruiter::find($request->id);
//        dd(Hash::check($request->old_password, self::$data->password));


//        if(Hash::check($request->old_password, self::$data->password)){
            self::$data->name= $request->name;
            self::$data->phone= $request->phone;
            self::$data->email= $request->email;
            self::$data->designation= $request->designation;
            self::$data->company_name= $request->company_name;
            self::$data->address= $request->address;
            if ($request->new_password){

                self::$data->password= Hash::make($request->new_password);
            }

            if ($request->file('company_logo')) {
                if (self::$data->company_logo) {
                    if (file_exists(self::$data->company_logo)) {
                        unlink(self::$data->company_logo);
                        self::$data->company_logo = self::saveImage($request);
                    }
                } else {
                    self::$data->company_logo = self::saveImage($request);
                }
            }
            self::$data->save();

    }
    public static function saveImage($request)
    {
        if ($request->file('company_logo')) {
            self::$image = $request->file('company_logo');
            self::$imageName = 'recruiter-' . rand() . '.' . self::$image->Extension();
            self::$imageDirectory = 'recruiter/';
            self::$imageUrl = self::$imageDirectory . self::$imageName;
            self::$image->move(self::$imageDirectory,self::$imageName);
            return self::$imageUrl;
        }
    }

    //Relationship with career
    public function reJobCircular() {
        return $this->hasMany(ReJobCircular::class);
    }
}
