<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ReJobCircular extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function recruiter() {
        return $this->belongsTo(Recruiter::class, 'recruiter_id', 'id');
    }
    public function department() {
        return $this->belongsTo(CompanyDepartment::class, 'department_id', 'id');
    }
    public function company() {
        return $this->belongsTo(Company::class, 'company_id', 'id');
    }
    public function productType() {
        return $this->belongsTo(ProductType::class, 'producttype_id', 'id');
    }

    //Relationship with reApplies
    public function reApplies() {
        return $this->hasMany(ReApply::class);
    }
}
