<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobCircular extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = ['id'];

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
    public function department() {
        return $this->belongsTo(CompanyDepartment::class, 'department_id', 'id');
    }
    public function company() {
        return $this->belongsTo(Company::class, 'company_id', 'id');
    }
    public function productType() {
        return $this->belongsTo(ProductType::class, 'producttype_id', 'id');
    }

    //Relationship with apply
    public function applies() {
        return $this->hasMany(Apply::class);
    }

}
