<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyDepartment extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    //Relationship with User
    public function users() {
        return $this->hasMany(User::class, 'department_id', 'id');
    }

    public function jobCirculars() {
        return $this->hasMany(JobCircular::class);
    }

    public function reJobCirculars() {
        return $this->hasMany(ReJobCircular::class);
    }
}
