<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserStatusChanged extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $isMerchandiser;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($user, $isMerchandiser)
    {
        $this->user = $user;
        $this->isMerchandiser = $isMerchandiser;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.user-status-changed')
                    ->with([
                        'userName' => $this->user->name,
                        'isMerchandiser' => $this->isMerchandiser,
                    ]);
    }
}
