<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendMailToAllUsers extends Mailable
{
    use Queueable, SerializesModels;

    public $subject;
    public $message;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subject, $message)
    {
        $this->subject = $subject;
        $this->message = $message;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.sendMailToAllUsers')
                    ->subject($this->subject)
                    ->with([
                        'messageContent' => $this->message,  // Avoid naming conflict with the class property
                    ]);
    }
}
