<?php

namespace App\Mail;

use App\Models\ReJobCircular;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class JobCircularMail extends Mailable
{
    use Queueable, SerializesModels;

    public $jobCircular;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(ReJobCircular $jobCircular)
    {
        $this->jobCircular = $jobCircular;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.jobCircular')
                    ->subject('New Job Circular Published')
                    ->with('jobCircular', $this->jobCircular);
    }
}
