<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CVUpdated extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($user)
    {
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        if($this->user->department_id == 13){
        return $this->subject('Welcome to MBABD - Your Membership Registration is Confirmed!')
                    ->view('emails.merchantizer_cv_updated');
        } else {
            return $this->subject('Welcome to MBABD - Your Membership Registration is Confirmed!')
            ->view('emails.cv_updated');
        }
    }
}
