<?php

namespace App\Listeners;

use App\Mail\JobCircularMail;
use App\Events\JobCircularCreated;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendJobCircularNotification
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(JobCircularCreated $event)
    {
        $jobCircular = $event->jobCircular;
        $department = $jobCircular->department;

        $users = $department->users;

        foreach ($users as $user) {
            Mail::to($user->email)->send(new JobCircularMail($jobCircular));
        }
    }
}
