<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class JobCircularUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'department_id' => 'nullable|numeric',
            'company_id' => 'nullable|numeric',
            'producttype_id' => 'nullable|numeric',
            'job_title' => 'nullable|string|max:255',
            'vacancy' => 'nullable|numeric',
            'responsibilities' => 'nullable|string',
            'experience' => 'nullable|string',
            'location' => 'nullable|string',
            'qualification' => 'nullable|string',
            'salary_range' => 'nullable|string',
            'others_facilities' => 'nullable|string',
            'deadline_till' => 'nullable|date',
            'company_logo' => 'nullable|mimes:jpeg,png,jpg,gif|max:2048',
        ];
    }
}
