<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class JobCircularStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'department_id' => 'required|numeric',
            'company_id' => 'required|numeric',
            'producttype_id' => 'required|numeric',
            'job_title' => 'required|string|max:255',
            'vacancy' => 'required|numeric',
            'responsibilities' => 'nullable|string',
            'experience' => 'required|string',
            'location' => 'required|string',
            'qualification' => 'nullable|string',
            'salary_range' => 'nullable|string',
            'others_facilities' => 'nullable|string',
            'deadline_till' => 'required|date',
            'company_logo' => 'nullable|mimes:jpeg,png,jpg,gif,pdf|max:2048',
            'job_banner' => 'nullable|mimes:jpeg,png,jpg,gif,pdf|max:2048',
        ];
    }
}
