<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CareerUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'designation' => 'nullable|string|max:255',
            'university' => 'nullable|string|max:255',
            'company_name' => 'nullable|string|max:255',
            'career_summery' => 'nullable|string',
            'skills' => 'nullable|string',
            'experience' => 'nullable|string',
            'education' => 'nullable|string',
            // 'resume' => 'nullable|mimes:pdf|max:2048',
            'office_idcard' => 'nullable|mimes:jpeg,png,jpg|max:2048',
        ];
    }
}
