<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CareerStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'designation' => 'required|string|max:255',
            'university' => 'required|string|max:255',
            'company_name' => 'required|string|max:255',
            'career_summery' => 'required|string',
            'skills' => 'required|string',
            'experience' => 'required|string',
            'education' => 'required|string',
            // 'resume' => 'required|mimes:pdf|max:2048',
            'office_idcard' => 'required|mimes:jpeg,png,jpg|max:2048',
        ];
    }
}
