<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CVBankStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'job_title' => 'required|numeric',
            'full_name' => 'required|string|max:255',
            'designation' => 'required|string|max:255',
            'location' => 'required|string|max:255',
            'career_summery' => 'required|string',
            'skills' => 'required|string',
            'experience' => 'required|string',
            'education' => 'required|string',
            'resume' => 'required|mimes:jpeg,png,jpg,pdf|max:2048',
            'office_idcard' => 'required|mimes:jpeg,png,jpg,pdf|max:2048',
        ];
    }
}
