<?php

namespace App\Http\Controllers;

use App\Models\Faq;
use App\Models\Blog;
use App\Models\Team;
use App\Models\User;
use App\Models\About;
use App\Models\Apply;
use App\Models\Banner;
use App\Models\Career;
use App\Models\Notice;
use App\Models\Counter;
use App\Models\Gallery;
use App\Models\Message;
use App\Models\Package;
use App\Models\Service;
use App\Models\Management;
use App\Models\JobCircular;
use App\Models\Testimonial;
use App\Models\Merchandiser;
use App\Models\VideoGallery;
use Illuminate\Http\Request;
use App\Models\ReJobCircular;
use App\Models\BannerAndTitle;
use App\Models\MemberProcedure;
use App\Models\RecruiterCompany;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class WebsiteController extends Controller
{
    public function home()
    {
        return view('frontend.home.home',[
            'services'=>Service::where('status',1)->where('service_home',1)->get(),
            'about'=>DB::table('abouts')->latest()->first(),
            'teams'=>Team::where('status',1)->where('add_home',1)->get(),
            'testimonials'=>Testimonial::where('status',1)->where('add_home',1)->get(),
            'info'=>DB::table('appointment_infos')->latest()->first(),
            'packages'=>Package::where('status',1)->where('add_home',1)->get(),
            'blogs'=>Blog::where('status',1)->where('add_home',1)->get(),
            'titles'=>BannerAndTitle::get(),
            'banners'=>Banner::get(),
            // 'counter'=>Counter::latest()->first(),
            // 'galleries'=>VideoGallery::where('status',1)->take('3')->get(),
            'gallery'=>VideoGallery::where('status',1)->latest()->first(),
            'notice'=>Notice::latest()->first(),
            'notices' => Notice::inRandomOrder()->limit(4)->get(),
        ]);
    }
    public function tech_web_notice_details($id)
    {
        return view('frontend.notice.notice_details',[
            'notice'=>Notice::where('id', $id)->first(),
            'notices' => Notice::where('id', '!=', $id)->get(),
            'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
        ]);
    }
    public function tech_web_services_details($id)
    {
        return view('frontend.services.service_details',[
            'service'=>Service::find($id),
            'services'=>Service::where('status',1)->where('service_home',1)->get(),
        ]);
    }

    public function tech_web_all_services()
    {

        return view('frontend.services.all_services',[
            'services'=>Service::where('status',1)->paginate(8),
            'banner'=>BannerAndTitle::where('page','services')->latest()->first(),
        ]);
    }

    public function tech_web_recruiter_details()
    {

        return view('frontend.recruiter.recruiter',[
            'recruiter'=>RecruiterCompany::latest()->first(),
            'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
        ]);

    }
    public function tech_web_cv_bank()
    {

        return view('frontend.cvbank.index',[
            'recruiter'=>RecruiterCompany::latest()->first(),
            'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
            'careers'=>Career::select(['id', 'user_id', 'designation', 'university', 'company_name', 'career_summery', 'skills', 'experience', 'education', 'updated_at'])->with('user')->paginate(1000),
        ]);
    }

    public function tech_web_cv_bank_resume($id)
    {
        $career = Career::where('id', $id)->first();

        return view('frontend.cvbank.resume', compact('career'));
    }

    public function tech_web_jobcircular_list()
    {

        return view('frontend.jobcircular.jobcircular',[
            'recruiter'=>RecruiterCompany::latest()->first(),
            'jobcirculars' => JobCircular::with(['user:id,name', 'department:id,company_department_name', 'company:id,company_name',
            'productType:id,product_name'])
            ->latest('id')
            ->select(['id', 'user_id', 'department_id','company_id', 'company_nam', 'producttype_id', 'job_title', 'company_logo', 'updated_at'])
            ->paginate(),
            'rejobcirculars' => ReJobCircular::with(['recruiter:id,name', 'department:id,company_department_name', 'company:id,company_name',
            'productType:id,product_name'])
            ->latest('id')
            ->select(['id', 'recruiter_id', 'department_id','company_id', 'company_nam', 'producttype_id', 'job_title', 'company_logo', 'updated_at'])
            ->paginate(),
            'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
        ]);
    }

    public function tech_web_orientate_member()
    {

        return view('frontend.orientation_member.orientation',[
            'users'=>User::with(['role', 'profile', 'adminProfileImage', 'career'])->where('is_merchandiser', 1)->where('role_id', 4)->paginate(4),
            'banner'=>BannerAndTitle::where('page','members')->latest()->first(),
        ]);
    }

    public function tech_web_member_forum()
    {
        return view('frontend.memberprocedure.member_forum', [
            'users' => User::where('department_id', 13)
                ->with(['memberRole'])
                ->paginate(20),
            'banner' => BannerAndTitle::where('page', 'members')->latest()->first(),
        ]);
    }

    //Message
    public function tech_web_member_message($recipient_id)
    {
        $recipient = User::findOrFail($recipient_id);
        $banner = BannerAndTitle::where('page', 'members')->latest()->first();
        return view('frontend.memberprocedure.send_message', compact('recipient', 'banner'));
    }

    public function tech_web_member_executive()
    {
        return view('frontend.memberprocedure.executive', [
            'users' => User::where('department_id', 13)
                ->with(['memberRole'])
                ->whereHas('memberRole', function ($query) {
                    $query->where('id', 6);
                })
                ->paginate(12),
            'banner' => BannerAndTitle::where('page', 'members')->latest()->first(),
        ]);
    }

    public function tech_web_member_advisory()
    {
        return view('frontend.memberprocedure.advisory', [
            'users' => User::where('department_id', 13)
                ->with(['memberRole'])
                ->whereHas('memberRole', function ($query) {
                    $query->where('id', 3);
                })
                ->paginate(12),
            'banner' => BannerAndTitle::where('page', 'members')->latest()->first(),
        ]);
    }

    public function tech_web_member_volunteer()
    {
        return view('frontend.memberprocedure.volunteer', [
            'users' => User::where('department_id', 13)
                ->with(['memberRole'])
                ->whereHas('memberRole', function ($query) {
                    $query->where('id', 5);
                })
                ->paginate(12),
            'banner' => BannerAndTitle::where('page', 'members')->latest()->first(),
        ]);
    }
    public function tech_web_member_presidium()
    {
        return view('frontend.memberprocedure.presidium', [
            'users' => User::where('department_id', 13)
                ->with(['memberRole'])
                ->whereHas('memberRole', function ($query) {
                    $query->where('id', 4);
                })
                ->paginate(12),
            'banner' => BannerAndTitle::where('page', 'members')->latest()->first(),
        ]);
    }

    public function tech_web_job_details($id)
    {
        return view('frontend.jobcircular.jobdetails',[
            'recruiter'=>RecruiterCompany::latest()->first(),
            'jobcircular' => JobCircular::find($id),
            'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
        ]);
    }

    public function tech_web_rejob_details($id)
    {
        return view('frontend.jobcircular.rejobdetails',[
            'recruiter'=>RecruiterCompany::latest()->first(),
            'rejobcircular' => ReJobCircular::find($id),
            'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
        ]);
    }

    public function tech_web_memberprocedure_details()
    {

        return view('frontend.memberprocedure.memberprocedure',[
            'memberprocedure'=>MemberProcedure::latest()->first(),
            'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
        ]);
    }

    public function tech_web_about_page()
    {
        return view('frontend.about.about_page',[
            'about'=>DB::table('abouts')->latest()->first(),
            'galleriess'=>Gallery::where('status',1)->get(),

            'galleries'=>VideoGallery::where('status',1)->get(),
            'banner'=>BannerAndTitle::where('page')->latest()->first(),
        ]);
    }
    public function tech_web_mission_vission_page()
    {
        return view('frontend.about.mission_vission',[
            'about'=>DB::table('abouts')->latest()->first(),
            'banner'=>BannerAndTitle::where('page')->latest()->first(),
            'memberprocedure'=>MemberProcedure::latest()->first(),
        ]);
    }

  public function tech_web_team_page()
    {
       return view('frontend.team.team_page',[
            'teams'=>Team::where('status',1)->get(),
            'banner'=>BannerAndTitle::where('page','doctors')->latest()->first(),
            'services'=>Service::get(),
        ]);
    }
    public function tech_web_management_page()
    {
        return view('frontend.management.management_page',[
            'managements'=>Management::where('status',1)->paginate(8),
            'banner'=>BannerAndTitle::where('page','managements')->latest()->first(),
        ]);
    }
    public function testimonial_page()
    {
        return view('frontend.testimonial.testimonial_page',[
            'testimonials'=>Testimonial::where('status',1)->paginate(8),
            'banner'=>BannerAndTitle::where('page','testimonial')->latest()->first(),
        ]);
    }
    // public function tech_web_appointment_page()
    // {
    //     return view('frontend.appointment.appointment_page',[
    //         'banner'=>BannerAndTitle::where('page','appointment')->latest()->first(),
    //         'services'=>Service::where('status',1)->where('service_home',1)->get(),

    //     ]);
    // }
    // public function tech_web_package_page()
    // {
    //     return view('frontend.package.package_page',[
    //         'packages'=>Package::where('status',1)->paginate(6),
    //         'banner'=>BannerAndTitle::where('page','packages')->latest()->first(),
    //     ]);
    // }
    public function tech_web_blogs_page()
    {
        return view('frontend.blogs.blogs_page',[
            'blogs'=>Blog::where('status',1)->paginate(6),
            'banner'=>BannerAndTitle::where('page','blogs')->latest()->first(),
        ]);
    }
    public function tech_web_blogs_details($id)
    {
        return view('frontend.blogs.blogs_details',[
            'blog'=>Blog::find($id),

        ]);
    }

    // public function tech_web_gallery_page()
    // {
    //     return view('frontend.gallery.gallery_page',[
    //         'galleries'=>Gallery::where('status',1)->get(),
    //         'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
    //     ]);
    // }
    // public function tech_web_video_gallery_page()
    // {
    //     return view('frontend.gallery.video_gallery_page',[
    //         'galleries'=>VideoGallery::where('status',1)->get(),
    //         'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
    //     ]);
    // }

    public function tech_web_contacts()
    {
        return view('frontend.contact.contact',[
            'banner'=>BannerAndTitle::where('page','contacts')->latest()->first(),
        ]);

    }


    // public function tech_web_faq_page()
    // {
    //     return view('frontend.faq.faq',[
    //         'faqs'=>Faq::where('status',1)->paginate(8),
    //         'banner'=>BannerAndTitle::where('page','gallery')->latest()->first(),
    //     ]);
    // }

}
