<?php

namespace App\Http\Controllers\Trash;

use App\Models\Recruiter;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Gate;

class RecruiterListTrashController extends Controller
{
    public function trash()
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('delete-recruiter');

        $recruiters = Recruiter::onlyTrashed()
        ->select(['id', 'name', 'email', 'designation', 'phone', 'company_logo', 'is_recruiter'])
        ->paginate(1000);

        return view('admin.recruiter.trash', compact('recruiters'));
    }

    public function restore($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('delete-recruiter');

        // dd($id);
        $recruiter = Recruiter::onlyTrashed()->where('id', $id)->first();
        $recruiter->restore();

        return redirect()->route('recruiters.index')->with('info', 'Recruiter Restored Successfully 🙂');
    }

    public function forceDelete($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('delete-recruiter');

        // dd($id);
        $recruiter = Recruiter::onlyTrashed()->where('id', $id)->first();
        // $destination = 'recruiter/' . $recruiter->company_logo;

        // if (File::exists($destination)) {
        //     File::delete($destination);
        // }

        if($recruiter->company_logo){
            $photo_location = $recruiter->company_logo;
            unlink($photo_location);
        }

        // $service->delete();
        $recruiter->forceDelete();

        return redirect()->back()->with('error', 'Recruiter Deleted Permanently');
    }
}
