<?php

namespace App\Http\Controllers\Trash;

use App\Models\JobCircular;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;

class JobCircularTrashController extends Controller
{
    public function trash()
    {
        Gate::authorize('delete-job-circular');

        $jobcirculars = JobCircular::onlyTrashed()
        ->with(['department:id,company_department_name', 'company:id,company_name',
        'productType:id,product_name'])
        ->latest('id')
        ->select(['id', 'department_id','company_id', 'producttype_id', 'job_title', 'company_logo', 'updated_at'])
        ->paginate(50);

        return view('admin.jobcircular.trash', compact('jobcirculars'));
    }

    public function restore($id)
    {
        Gate::authorize('delete-job-circular');

        $jobcircular = JobCircular::onlyTrashed()->where('id', $id)->first();
        $jobcircular->restore();

        return redirect()->route('jobcircular.index')->with('info', 'Job Circular Restored Successfully 🙂');
    }

    public function forceDelete($id)
    {
        Gate::authorize('delete-job-circular');
        $jobcircular = JobCircular::onlyTrashed()->where('id', $id)->first();
        if($jobcircular->company_logo != 'default_product.jpg'){
            $photo_location_one = 'jobcircular/'.$jobcircular->company_logo;
            unlink($photo_location_one);
        }
        if($jobcircular->job_banner != 'default_product.jpg'){
            $photo_location_two = 'jobcircular/'.$jobcircular->job_banner;
            unlink($photo_location_two);
        }
        $jobcircular->forceDelete();

        return redirect()->back()->with('error', 'Job Circular Deleted Permanently');
    }
}
