<?php

namespace App\Http\Controllers;

use App\Models\Apply;
use App\Models\Company;
use App\Models\ReApply;
use App\Models\Recruiter;
use App\Mail\JobPublished;
use App\Models\Department;
use App\Models\ProductType;
use Illuminate\Http\Request;
use App\Models\ReJobCircular;
use App\Models\BannerAndTitle;
use App\Models\RecruiterCompany;
use App\Models\CompanyDepartment;
use App\Events\JobCircularCreated;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Http\Requests\JobCircularStoreRequest;
use App\Http\Requests\JobCircularUpdateRequest;

class RecruiterDashboardController extends Controller
{
    public function recruiterDashboard()
    {
        $recruiterCompany = RecruiterCompany::latest()->first();
        $recruiter = Auth::guard('recruiter')->user();
        $banner = BannerAndTitle::where('page','gallery')->latest()->first();
        $departments = CompanyDepartment::select(['id', 'company_department_name'])->get();
        $companies = Company::select(['id', 'company_name'])->get();
        $producttypes = ProductType::select(['id', 'product_name'])->get();
        return view('frontend.recruiter.recruiter_dashboard', compact(
            'recruiterCompany',
            'banner',
            'recruiter',
            'departments',
            'companies',
            'producttypes',
        ));
    }

    public function applyJob()
{
    $recruiterId = Auth::guard('recruiter')->id();

    $reapplies = ReApply::with(['reJobCircular.department', 'user.profile.profileImage'])
        ->whereHas('reJobCircular', function($query) use ($recruiterId) {
            $query->where('recruiter_id', $recruiterId);
        })
        ->select(['id', 'user_id', 'rejobcircular_id', 'subject', 'is_active', 'updated_at'])
        ->latest('id')
        ->paginate(1000);

    $rejobcirculars = ReJobCircular::with(['recruiter:id,name', 'department:id,company_department_name', 'company:id,company_name', 'productType:id,product_name'])
        ->where('recruiter_id', $recruiterId)
        ->select(['id', 'recruiter_id', 'department_id', 'company_id', 'producttype_id', 'company_nam', 'job_title', 'company_logo', 'updated_at'])
        ->latest('id')
        ->paginate(1000);

    $recruiter = RecruiterCompany::latest()->first();

    return view('frontend.recruiter.jobapplication', compact('reapplies', 'recruiter', 'rejobcirculars'));
}


    public function myjobview($id)
    {
        $rejobcircular = ReJobCircular::where('id', $id)->first();
        $recruiter = RecruiterCompany::latest()->first();
        $banner = BannerAndTitle::where('page','gallery')->latest()->first();

        return view('frontend.recruiter.myjobdetails', compact('rejobcircular', 'recruiter', 'banner'));
    }
    public function myJobEdit($id)
    {
        $rejobcircular = ReJobCircular::where('id', $id)->first();
        $recruiter = RecruiterCompany::latest()->first();
        $departments = CompanyDepartment::select(['id', 'company_department_name'])->get();
        $companies = Company::select(['id', 'company_name'])->get();
        $producttypes = ProductType::select(['id', 'product_name'])->get();
        $banner = BannerAndTitle::where('page','gallery')->latest()->first();

        return view('frontend.recruiter.editjob', compact(
            'rejobcircular',
            'recruiter',
            'departments',
            'companies',
            'producttypes',
            'banner'
        ));
    }

    public function recruiterUpdate(Request $request)
    {
        // dd($request->all());
        Recruiter::update_recruiterInfo($request);
        return back()->with('message','Your Information updated successfully');
    }

    public function updatePassword(Request $request)
    {
        //authorize this user to access/give access to admin dashboard
        // Gate::authorize('password-update');
        // dd($request->all());
        $recruiter = Auth::guard('recruiter')->user();
        $hashedPassword = $recruiter->password;
        //existing password === request password
        if (Hash::check($request->old_password, $hashedPassword)) {
            //new password == old stored password
            if(!Hash::check($request->password, $hashedPassword)) {
                $recruiter->update([
                    'password' => Hash::make($request->password),
                ]);

            Auth::guard('recruiter')->logout();
            // Toastr::success("Password Updated Successfully 🙂");
                return redirect()->route('login.page')->with('message', 'Password Updated Successfully');
            } else {
                // Toastr::error('New Password cannot be the same as old pasword');
                // return redirect()->back();
                return redirect()->back()->with('error','New Password cannot be the same as old pasword');
            }
        } else {
            // Toastr::error("Credentials doesn't match");
            //     return redirect()->back();
            return redirect()->back()->with('error',"Credentials doesn't match");
        }
    }

    public function jobStore(JobCircularStoreRequest $request) {
        // dd($request->all());

        $imageNameOne = null;
        // Check if a company logo is uploaded
        if ($request->hasFile('company_logo') && $request->file('company_logo')->isValid()) {
            // Generate a unique name for the image
            $imageNameOne = time().'.'.$request->company_logo->extension();
            // Move the uploaded file to a public directory
            $request->company_logo->move(public_path('jobcircular'), $imageNameOne);
        }

        $imageNameTwo = null;
        // Check if a company logo is uploaded
        if ($request->hasFile('job_banner') && $request->file('job_banner')->isValid()) {
            // Generate a unique name for the image
            $imageNameTwo = time().'.'.$request->job_banner->extension();
            // Move the uploaded file to a public directory
            $request->job_banner->move(public_path('jobcircular'), $imageNameTwo);
        }

         // Create the job circular
        $jobCircular = ReJobCircular::create([
            'recruiter_id' => Auth::guard('recruiter')->id(),
            'department_id' => $request->department_id,
            'company_id' => $request->company_id,
            'producttype_id' => $request->producttype_id,
            'job_title' => $request->job_title,
            'company_nam' => $request->company_nam,
            'vacancy' => $request->vacancy,
            'responsibilities' => $request->responsibilities,
            'experience' => $request->experience,
            'location' => $request->location,
            'qualification' => $request->qualification,
            'salary_range' => $request->salary_range,
            'others_facilities' => $request->others_facilities,
            'deadline_till' => $request->deadline_till,
            'company_logo' => $imageNameOne,
            'job_banner' => $imageNameTwo,
        ]);

        event(new JobCircularCreated($jobCircular));
        return redirect()->back()->with('message', 'Job Circular Created Successfully 🙂');
    }

    public function myJobUpdate(JobCircularUpdateRequest $request, $id)
    {
        // dd($request->all());

        $rejobcircular = ReJobCircular::findOrFail($id);

        // Update image if a new one is provided
        if ($request->hasFile('company_logo') && $request->file('company_logo')->isValid()) {
            // Delete the old image
            if ($rejobcircular->company_logo) {
                unlink('jobcircular/' . $rejobcircular->company_logo);
            }
            // Upload new image
            $imageNameOne = time().'.'.$request->company_logo->extension();
            $request->company_logo->move(public_path('jobcircular'), $imageNameOne);
            $rejobcircular->company_logo = $imageNameOne;
        }

        // Update image if a new one is provided
        if ($request->hasFile('job_banner') && $request->file('job_banner')->isValid()) {
            // Delete the old image
            if ($rejobcircular->job_banner) {
                unlink('jobcircular/' . $rejobcircular->job_banner);
            }
            // Upload new image
            $imageNameTwo = time().'.'.$request->job_banner->extension();
            $request->job_banner->move(public_path('jobcircular'), $imageNameTwo);
            $rejobcircular->job_banner = $imageNameTwo;
        }

        $rejobcircular->update([
            'department_id' => $request->department_id,
            'company_id' => $request->company_id,
            'producttype_id' => $request->producttype_id,
            'job_title' => $request->job_title,
            'company_nam' => $request->company_nam,
            'vacancy' => $request->vacancy,
            'responsibilities' => $request->responsibilities,
            'experience' => $request->experience,
            'location' => $request->location,
            'qualification' => $request->qualification,
            'salary_range' => $request->salary_range,
            'others_facilities' => $request->others_facilities,
            'deadline_till' => $request->deadline_till,
        ]);

        return redirect()->back()->with('message', 'Job Circular Updated Successfully 🙂');
    }

    public function myJobDelete($id)
    {
        $rejobcircular = ReJobCircular::where('id', $id)->first();
        if($rejobcircular->company_logo){
            $photo_location_one = 'jobcircular/'.$rejobcircular->company_logo;
            unlink($photo_location_one);
        }
        if($rejobcircular->job_banner){
            $photo_location_two = 'jobcircular/'.$rejobcircular->job_banner;
            unlink($photo_location_two);
        }
        $rejobcircular->delete();

        return redirect()->back()->with('error', 'Job Circular Deleted Permanently');
    }

    public function applyJobView($id)
    {

        $apply = ReApply::where('id', $id)->first();
        $recruiter = RecruiterCompany::latest()->first();

        return view('frontend.recruiter.applicantdetails', compact('apply', 'recruiter'));
    }
    public function applyJobEdit($id)
    {

        $apply = ReApply::where('id', $id)->first();
        $recruiter = RecruiterCompany::latest()->first();
        $banner = BannerAndTitle::where('page','gallery')->latest()->first();

        return view('frontend.recruiter.applicantedit', compact('apply', 'recruiter', 'banner'));
    }

    public function applyJobUpdate(Request $request, $id)
    {
        // dd($request->all());
        $apply = ReApply::where('id', $id)->first();
        $apply->update([
            'is_active' => $request->filled('is_active'),
        ]);

        return redirect()->route('applyjob.index')->with('message', 'Successfully Applied🙂');
    }

    public function applyJobDelete($id)
    {
        // dd($request->all());
        $apply = ReApply::where('id', $id)->first();
        $apply->delete();

        return redirect()->back()->with('error', 'Deleted Permanently');
    }
}
