<?php

namespace App\Http\Controllers;

use App\Http\Requests\RecruiterRegisterStoreRequest;
use App\Http\Requests\RecruiterStoreRequest;
use App\Models\Recruiter;
use Illuminate\Http\Request;
use App\Models\BannerAndTitle;
use App\Models\RecruiterCompany;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class RecruiterController extends Controller
{

    public function registerPage()
    {
        $recruiter = RecruiterCompany::latest()->first();
        $banner = BannerAndTitle::where('page','gallery')->latest()->first();
        return view('frontend.recruiter.register', compact('recruiter', 'banner'));
    }

    public function loginPage()
    {
        $recruiter = RecruiterCompany::latest()->first();
        $banner = BannerAndTitle::where('page','gallery')->latest()->first();
        return view('frontend.recruiter.login', compact('recruiter', 'banner'));
    }

    public function registerStore(RecruiterRegisterStoreRequest $request)
    {
        // dd($request->all());
        $recruiter = Recruiter::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'designation' => $request->designation,
            'company_name' => $request->company_name,
            'password' => Hash::make($request->password),
        ]);

        //make a credentials array
        $credentials = [
            'email' => $request->email,
            'password' => $request->password,
        ];

        //login attempt if success then redirect home

        if(Auth::guard('recruiter')->attempt($credentials)) {
            $request->session()->regenerate();
            return redirect()->route('recruiter.dashboard');
        }
    }

    public function loginStore(RecruiterStoreRequest $request)
    {
        //make a credentials array
        $credentials = [
            'email' => $request->email,
            'password' => $request->password,
        ];

        // login attempt if success then redirect dashboard
        if(Auth::guard('recruiter')->attempt($credentials, $request->filled('remember'))){
            $request->session()->regenerate();
            return redirect()->route('recruiter.dashboard')->with('message', 'Login Successfully!');
        }

        // return error message
        return back()->withErrors([
            'email' => 'Wrong Credentials found!'
        ])->onlyInput('email');
    }

    public function recruiterLogout(Request $request)
    {
        Auth::guard('recruiter')->logout();

        $request->session()->invalidate();
        // $request->session()->regenerateToken();

        return redirect()->route('login.page');
    }
}
