<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\RecruiterCompany;
use Illuminate\Support\Facades\Gate;

class RecruiterCompanyController extends Controller
{
    public function tech_web_list_recruiter()
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('index-recruiter');

        return view('admin.recruiter_company.index',[
            'recruiters'=>RecruiterCompany::get(),
        ]);

    }

    public function tech_web_store_recruiter(Request $request)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('create-recruiter');

        // dd($request->all());
        RecruiterCompany::save_recruiter($request);
        return back()->with('message','recruiter added successfully');
    }

    public function tech_web_edit_recruiter($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('edit-recruiter');

        return view('admin.recruiter_company.edit',[
            'recruiter'=>RecruiterCompany::find($id),
        ]);
    }

    public function tech_web_update_recruiter(Request $request)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('edit-recruiter');

        RecruiterCompany::update_recruiter($request);
        return redirect()->route('list.recruiter')->with('message','recruiter update successfully');
    }

}
