<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Career;
use App\Mail\CVUpdated;
use App\Models\Profile;
use App\Models\ProfileImage;
use Illuminate\Http\Request;
use App\Models\BannerAndTitle;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Http\Requests\CareerStoreRequest;
use App\Http\Requests\CareerUpdateRequest;
use App\Http\Requests\ProfilePasswordChangeRequest;

class ProfileController extends Controller
{
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function customerDashboard()
    {
        $user = Auth::user();
        $profile = Profile::where('user_id', Auth::id())->first();
        $career = Career::where('user_id', Auth::id())->first();
        $banner = BannerAndTitle::where('page','contacts')->latest()->first();
        if($profile) {
            $profileImage = ProfileImage::where('profile_id', Auth::user()->profile->id)->first();
            return view('frontend.customer.customer_dashboard', compact('user', 'banner', 'profile', 'profileImage', 'career'));
        } else {
            return view('frontend.customer.customer_dashboard', compact('user', 'banner', 'profile', 'career'));
        }

    }

    public function customerUpdate(Request $request)
    {
        // dd($request->all());
        User::update_profile($request);
        return back()->with('message','Your Information updated successfully');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function customerInfoStore(Request $request)
    {
        //authorize this user to access/give access to admin dashboard
        // Gate::authorize('profile-update');
        // dd($request->all());
        $profile = $request->all();
        $profile['user_id'] = Auth::id();

        $existing_profile = Profile::where('user_id', Auth::id())->first();
        if ($existing_profile) {
            $existing_profile->update($profile);

        } else {
            $profile = Profile::create([
            'user_id' => Auth::id(),
            'nid_num' => $request->nid_num,
            'contact_number' => $request->contact_number,
            'address' => $request->address,
            'blood_group' => $request->blood_group,
            'blood_donner' => $request->blood_donner,
            'date_of_birth' => $request->date_of_birth,
            'gender' => $request->gender,
            'marital_status' => $request->marital_status,
            'facebook' => $request->facebook,
            'twitter' => $request->twitter,
            'linkedIn' => $request->linkedIn,
            'Instagram' => $request->Instagram,
        ]);
        }
        return redirect()->back()->with('message', 'Profile Updated Successfully');

    }

    public function careerStoreOrUpdate(Request $request, $id = null)
    {
        // dd($request->all());
        $validatedData = $request->validate([
            'designation' => 'required|string',
            'university' => 'required|string',
            'company_name' => 'required|string',
            'career_summery' => 'required|string',
            'skills' => 'required|string',
            'experience' => 'required|string',
            'education' => 'required|string',
            'extra_cariculam' => 'required|string',
            'language' => 'required|string',
            'professional_training' => 'required|string',
            'reference' => 'required|string',
            'declaration' => 'required|string',
            'office_idcard' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // Making office_idcard nullable as it's optional during update
        ]);

        $careerData = [
            'user_id' => Auth::id(),
            'designation' => $validatedData['designation'],
            'university' => $validatedData['university'],
            'company_name' => $validatedData['company_name'],
            'career_summery' => $validatedData['career_summery'],
            'skills' => $validatedData['skills'],
            'experience' => $validatedData['experience'],
            'education' => $validatedData['education'],
            'extra_cariculam' => $validatedData['extra_cariculam'],
            'language' => $validatedData['language'],
            'professional_training' => $validatedData['professional_training'],
            'reference' => $validatedData['reference'],
            'declaration' => $validatedData['declaration'],
        ];

        // Check if there is a file uploaded for office_idcard
        if ($request->hasFile('office_idcard') && $request->file('office_idcard')->isValid()) {
            $imageName = time().'.'.$request->office_idcard->extension();
            $request->office_idcard->move(public_path('idcard'), $imageName);
            $careerData['office_idcard'] = $imageName;

            // If updating, unlink the previous image
            if ($id) {
                $career = Career::where('user_id', Auth::id())->findOrFail($id);
                if ($career && $career->office_idcard) {
                    $previousImagePath = public_path('idcard').'/'.$career->office_idcard;
                    if (file_exists($previousImagePath)) {
                        unlink($previousImagePath);
                    }
                }
            }
        }

        if ($id) {
            $career = Career::where('user_id', Auth::id())->findOrFail($id);
            if ($career) {
                // Update existing career
                $career->update($careerData);
            }
        } else {
            // Create new career
            Career::create($careerData);
        }

        // Send email notification
        Mail::to(Auth::user()->email)->send(new CVUpdated(Auth::user()));

        return redirect()->back()->with('message', 'CV Updated Successfully');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getUpdatePassword()
    {
        //authorize this user to access/give access to admin dashboard
        // Gate::authorize('password-update');
        // return view('admin.pages.profile.update_password');
    }

    public function updatePassword(ProfilePasswordChangeRequest $request)
    {
        //authorize this user to access/give access to admin dashboard
        // Gate::authorize('password-update');
        // dd($request->all());
        // Get the currently authenticated user
        $user = Auth::user();
        $hashedPassword = $user->password;

        // Check if the old password matches the current password
        if (Hash::check($request->old_password, $hashedPassword)) {

            // Check if the new password is not the same as the old password
            if (!Hash::check($request->password, $hashedPassword)) {

                // Check if the new password matches the confirmation
                if ($request->password === $request->password_confirmation) {
                    // Update the user's password
                    $user->update([
                        'password' => Hash::make($request->password),
                    ]);

                    // Logout the user after password change for security reasons
                    Auth::logout();

                    // Redirect to login page with a success message
                    return redirect()->route('login')->with('message', 'Password Updated Successfully');
                } else {
                    // Redirect back with an error message if the new password confirmation does not match
                    return redirect()->back()->with('error', 'The new password confirmation does not match');
                }
            } else {
                // Redirect back with an error message if the new password matches the old password
                return redirect()->back()->with('error', 'New Password cannot be the same as old password');
            }
        } else {
            // Redirect back with an error message if the old password does not match
            return redirect()->back()->with('error', "Current password does not match our records");
        }
    }

    public function viewResume($user_id)
    {
        // dd($user_id);
        $career = Career::where('user_id', Auth::id())->first();
        // $banner = BannerAndTitle::where('page','contacts')->latest()->first();

        return view('frontend.customer.resume', compact('career'));
    }
}
