<?php

namespace App\Http\Controllers;

use App\Models\ProductType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class ProductController extends Controller
{
    public function tech_web_list_product()
    {
        Gate::authorize('index-job-circular');
        return view('admin.product.index',[
            'product_types'=>ProductType::get()
        ]);

    }

    public function tech_web_store_product(Request $request)
    {
        Gate::authorize('create-job-circular');
        // dd($request->all());
        ProductType::save_product($request);
        return back()->with('message','Product Added Successfully');

    }

    public function tech_web_edit_product($id)
    {
        Gate::authorize('edit-job-circular');
        return view('admin.product.edit',[
            'product_type'=>ProductType::find($id),
        ]);
    }

    public function tech_web_update_product(Request $request)
    {
        Gate::authorize('edit-job-circular');
        // dd($request->all());
        ProductType::update_product($request);
        return redirect()->route('list.product')->with('message','Product Updated Successfully');
    }

    public function tech_web_delete_product($id)
    {
        Gate::authorize('delete-job-circular');
        // dd($id);
        $product_type = ProductType::find($id);
        $product_type->delete();
        return back()->with('message','Product Deleted Successfully');
    }
}
