<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Message;
use Illuminate\Http\Request;
use App\Models\BannerAndTitle;
use Illuminate\Support\Facades\Auth;

class MessageController extends Controller
{
    public function view_message()
    {
        // Fetches the latest banner and title related to the contact page
        $banner = BannerAndTitle::where('page', 'contact')->latest()->first();

        // Fetches messages where the authenticated user is either the sender or recipient
        $messages = Message::where('sender_id', Auth::id())
                            ->orWhere('recipient_id', Auth::id())
                            ->with(['sender', 'recipient'])
                            ->latest() // Order messages by the latest first
                            ->get();

        // Groups messages by sender ID
        $groupedMessages = $messages->groupBy(function ($message) {
            return ($message->sender_id == Auth::id()) ? $message->recipient_id : $message->sender_id;
        });

        // Extracts unique senders
        $uniqueSenders = $groupedMessages->keys()->map(function ($senderId) {
            return User::find($senderId);
        });

        // Passes data to the view and renders the inbox view
        return view('frontend.inbox.inbox', compact('banner', 'groupedMessages', 'uniqueSenders', 'messages'));
    }

    public function store_message(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'recipient_id' => 'required|exists:users,id',
            'message_description' => 'required|string|max:5000',
        ]);

        $message = new Message();
        $message->sender_id = auth()->id(); // Assumes the user is authenticated
        $message->recipient_id = $request->recipient_id;
        $message->message_description = $request->message_description;
        $message->save();

        return redirect()->back()->with('message', 'Message sent successfully!');
    }


}
