<?php

namespace App\Http\Controllers;

use App\Models\Logo;
use App\Models\User;
use App\Models\Banner;
use App\Models\Counter;
use App\Models\FooterDetail;
use App\Models\WebsiteLinks;
use Illuminate\Http\Request;
use App\Models\BannerAndTitle;
use App\Models\AdminProfileImage;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;

class GeneralController extends Controller
{
    public function tech_web_general_settings()
    {
        Gate::authorize('update-setting');
        
        return view('admin.general.general',[
            'banner_titles'=>BannerAndTitle::get(),
            'logo'=>Logo::latest()->first(),
            'links'=>WebsiteLinks::latest()->first(),
            // 'counter'=>Counter::latest()->first(),
            'footer'=>FooterDetail::latest()->first(),
            'banners'=>Banner::get(),
        ]);
    }

    public function tech_web_profile_settings()
    {
//        return User::where('id',Auth::user()->id)->first();
        return view('admin.profile.profile',[
            'user'=>User::where('id',Auth::user()->id)->first(),
        ]);
    }

    public function tech_web_profileimage_settings()
    {
        $adminProfileImage = AdminProfileImage::where('user_id', Auth::user()->id)->first();
        return view('admin.profile.profile_image', compact( 'adminProfileImage'));

    }

    public function tech_web_store_profile(Request $request)
    {
        // dd($request->all());
        AdminProfileImage::save_profileImage($request);
        return back()->with('message','Profile Image Update Successfully');
    }

    public function tech_web_update_profile(Request $request)
    {
        // dd($request->all());
        AdminProfileImage::update_profileImage($request);
        return back()->with('message','Profile Image Update Successfully');
    }
}
