<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class BlogController extends Controller
{
    public function tech_web_add_blogs()
    {
        return view('admin.blogs.blogs',[
            'blogs'=>Blog::get()
        ]);

    }

    public function tech_web_store_blogs(Request $request)
    {
        Blog::save_blogs($request);
        return back()->with('message','Blogs added successfully');
    }

    public function tech_web_edit_blogs($id)
    {
        return view('admin.blogs.edit_blogs',[
            'blog'=>Blog::find($id),
        ]);
    }

    public function tech_web_update_blogs(Request $request)
    {
        Blog::update_blogs($request);
        return back()->with('message','Blogs update successfully');
    }

    public function tech_web_delete_blogs($id)
    {
        // dd($id);
        $blog = Blog::find($id);

        $destination = $blog->main_image;
        if (File::exists($destination)) {
            File::delete($destination);
        }

        $destination1 = $blog->banner_image;
        if (File::exists($destination1)) {
            File::delete($destination1);
        }

        $destination2 = $blog->details_image1;
        if (File::exists($destination2)) {
            File::delete($destination2);
        }

        $destination3 = $blog->details_image2;
        if (File::exists($destination3)) {
            File::delete($destination3);
        }
        $destination4 = $blog->details_image3;
        if (File::exists($destination4)) {
            File::delete($destination4);
        }
        
        $blog->delete();
        
        return back()->with('message','Post deleted successfully');

    }
}
