<?php

namespace App\Http\Controllers;

use App\Models\Apply;
use App\Models\ReApply;
use App\Models\JobCircular;
use Illuminate\Http\Request;
use App\Models\ReJobCircular;
use App\Models\BannerAndTitle;
use Illuminate\Support\Facades\Auth;

class ApplyController extends Controller
{
    public function jobHistory()
    {
        $applies = Apply::latest('id')->with('jobCircular', 'user')
        ->where('user_id', Auth::user()->id)
        ->select(['id', 'user_id', 'jobcircular_id', 'subject', 'is_active', 'updated_at'])
        ->paginate(1000);
        $reapplies = ReApply::latest('id')->with('reJobCircular', 'user')
        ->where('user_id', Auth::user()->id)
        ->select(['id', 'user_id', 'rejobcircular_id', 'subject', 'is_active', 'updated_at'])
        ->paginate(1000);
        $banner = BannerAndTitle::where('page','contacts')->latest()->first();

        return view('frontend.customer.job_history', compact('applies', 'banner', 'reapplies'));
    }

    public function applyJobStore(Request $request)
    {
        // dd($request->all());
         // Find the job circular the user is applying for
        $jobCircular = JobCircular::findOrFail($request->job_title);

        // Check if the user has already applied for this job
        $existingApplication = Apply::where('user_id', Auth::user()->id)
        ->where('jobcircular_id', $jobCircular->id)
        ->exists();

        if ($existingApplication) {
            return redirect()->back()->with('error', 'You have already applied for this job');
        }

        // Check if the user is eligible to apply for this job
        if (Auth::user()->department_id == $jobCircular->department_id) {
            // Create a new application
            if (Auth::user()->career) {
                // Check if the deadline has passed
                if($jobCircular->deadline_till >= now()) {
                    Apply::create([
                        'user_id' => Auth::user()->id,
                        'jobcircular_id' => $jobCircular->id,
                        'subject' => $request->subject,
                        'application_details' => $request->application_details,
                    ]);
                    // Redirect back with success message
                    return redirect()->back()->with('message', 'Successfully Applied🙂');
                } else {
                    // Redirect back with error message
                    return redirect()->back()->with('error', 'Application deadline has passed for this job');
                }
            } else {
                // Redirect back with error message
                return redirect()->back()->with('error', 'First you have to update your cv before applying for this job');
            }
        } else {
            // Redirect back with error message
            return redirect()->back()->with('error', 'You are not eligible for this job');
        }

    }
    public function reApplyJobStore(Request $request)
    {
        // dd($request->all());

        // return redirect()->back()->with('message', 'Successfully Applied🙂');
        $jobCircular = ReJobCircular::findOrFail($request->job_title);

        // Check if the user has already applied for this job
        $existingApplication = ReApply::where('user_id', Auth::user()->id)
        ->where('rejobcircular_id', $jobCircular->id)
        ->exists();

        if ($existingApplication) {
            return redirect()->back()->with('error', 'You have already applied for this job');
        }

        // Check if the user is eligible to apply for this job
        if (Auth::user()->department_id == $jobCircular->department_id) {
            // Create a new application
            if (Auth::user()->career) {
                // Check if the deadline has passed
                if($jobCircular->deadline_till >= now()) {
                    ReApply::create([
                        'user_id' => Auth::user()->id,
                        'rejobcircular_id' => $jobCircular->id,
                        'subject' => $request->subject,
                        'application_details' => $request->application_details,
                    ]);
                    // Redirect back with success message
                    return redirect()->back()->with('message', 'Successfully Applied🙂');
                } else {
                    // Redirect back with error message
                    return redirect()->back()->with('error', 'Application deadline has passed for this job');
                }
            } else {
                // Redirect back with error message
                return redirect()->back()->with('error', 'First you have to update your cv before applying for this job');
            }
        } else {
            // Redirect back with error message
            return redirect()->back()->with('error', 'You are not eligible for this job');
        }
    }

    public function applyJobShow($id)
    {
        $apply = Apply::where('id', $id)->first();
        $banner = BannerAndTitle::where('page','contacts')->latest()->first();

        return view('frontend.customer.view_job_history' , compact('apply', 'banner'));
    }
    public function reApplyJobShow($id)
    {
        $apply = ReApply::where('id', $id)->first();
        $banner = BannerAndTitle::where('page','contacts')->latest()->first();

        return view('frontend.customer.review_job_history' , compact('apply', 'banner'));
    }
}
