<?php

namespace App\Http\Controllers\Admin;

use App\Models\Apply;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use App\Http\Requests\CVBankUpdateRequest;

class ResumeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        Gate::authorize('index-cv');

        $applies = Apply::latest('id')->with(['jobCircular', 'user'])
        ->select(['id', 'user_id', 'jobcircular_id', 'subject', 'is_active', 'updated_at'])
        ->paginate(1000);

        return view('admin.resume.index', compact('applies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $apply = Apply::where('id', $id)->first();
        return view('admin.resume.edit', compact('apply'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        Gate::authorize('edit-cv');

        // dd($request->all());
        $apply = Apply::where('id', $id)->first();
        $apply->update([
            'is_active' => $request->filled('is_active'),
        ]);

        return redirect()->route('resume.index')->with('message', 'Approved Successfully 🙂');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Gate::authorize('delete-cv');
        // dd($id);
        $apply = Apply::where('id', $id)->first();
        $apply->delete();

        return redirect()->back()->with('warning', 'CV Deleted Successfully');
    }
}
