<?php

namespace App\Http\Controllers\Admin;

use App\Models\Recruiter;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;

class RecruiterListController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('index-recruiter');

        $recruiters = Recruiter::
        select(['id', 'name', 'email', 'designation', 'phone', 'company_logo', 'is_recruiter'])
        ->paginate(1000);

        return view('admin.recruiter.index', compact('recruiters'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('edit-recruiter');

        $recruiter = Recruiter::where('id', $id)->first();

        return view('admin.recruiter.edit', compact('recruiter'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('edit-recruiter');

        // dd($request->all());
        $recruiter = Recruiter::where('id', $id)->first();

        $recruiter->update([
            // 'role_id' => $request->role_id,
            // 'name' => $request->name,
            // 'email' => $request->email,
            // 'password' => Hash::make($request->password),
            'is_recruiter' => $request->is_recruiter,
            'is_approved' => $request->filled('is_approved'),
        ]);

        return redirect()->route('recruiters.index')->with('message', 'Recruiter Updated Successfully 🙂');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('delete-recruiter');

        $recruiter = Recruiter::where('id', $id)->first();
        $recruiter->delete();

        return redirect()->route('recruiters.index')->with('warning', 'Recruiter Deleted Successfully');
    }
}
