<?php

namespace App\Http\Controllers\Admin;

use App\Models\Notice;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class NoticeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $notices = Notice::latest('id')->select(['id', 'title', 'description', 'poster', 'updated_at'])->paginate();

        return view('admin.notice.notice', compact('notices'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $imageNameOne = null;
        // Check if a company logo is uploaded
        if ($request->hasFile('poster') && $request->file('poster')->isValid()) {
            // Generate a unique name for the image
            $imageNameOne = time().'.'.$request->poster->extension();
            // Move the uploaded file to a public directory
            $request->poster->move(public_path('notice'), $imageNameOne);
        }

        Notice::create([
            'title' => $request->title,
            'description' => $request->description,
            'poster' => $imageNameOne,
        ]);

        return redirect()->back()->with('message', 'Notice Created Successfully 🙂');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $notice = Notice::where('id', $id)->first();
        return view('admin.notice.edit', compact('notice'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request->all());
        $notice = Notice::findOrFail($id);
        // $jobcircular = JobCircular::findOrFail($id);

        // Update image if a new one is provided
        if ($request->hasFile('poster') && $request->file('poster')->isValid()) {
            // Delete the old image
            if ($notice->poster) {
                unlink('notice/' . $notice->poster);
            }
            // Upload new image
            $imageNameOne = time().'.'.$request->poster->extension();
            $request->poster->move(public_path('notice'), $imageNameOne);
            $notice->poster = $imageNameOne;
        }
        $notice->update([
            'title' => $request->title,
            'description' => $request->description,
        ]);

        return redirect()->route('notices.index')->with('message', 'Notice Updated Successfully 🙂');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $notice = Notice::where('id', $id)->first();
        if($notice->poster != 'default_product.jpg'){
            $photo_location_one = 'notice/'.$notice->poster;
            unlink($photo_location_one);
        }
        $notice->delete();

        return redirect()->back()->with('error', 'Notice Deleted Successfully');
    }
}
