<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use App\Models\MemberRole;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Merchandiser;

class MerchandiserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::where('department_id', 13)->with(['memberRole'])->paginate(1000);

        return view('admin.merchandiser_role.merchandiser_role', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        // Merchandiser::create([
        //     'user_id' => $request->user_id,
        //     'member_role_id' => $request->member_role_id,
        // ]);

        // return redirect()->back()->with('message', 'Merchandiser Role Assigned Successfully 🙂');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::where('id', $id)->first();
        return view('admin.merchandiser_role.idcard', compact('user'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::where('id', $id)->first();
        $member_roles = MemberRole::latest('id')->select(['id', 'member_role_name'])->get();
        return view('admin.merchandiser_role.edit', compact('user', 'member_roles'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request->all());
        $user = User::where('id', $id)->first();

        $user->update([
            'member_role_id' => $request->member_role_id,
        ]);
        return redirect()->route('merchandiser.index')->with('message', 'Merchandiser Role Updated Successfully 🙂');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // dd($id);
        // $user = User::where('id', $id)->first();
        // $user->delete();

        // return redirect()->back()->with('error', 'Merchandiser User Deleted Successfully');
    }
}
