<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MemberRole;
use Illuminate\Http\Request;

class MemberRoleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $member_roles = MemberRole::latest('id')->select(['id', 'member_role_name', 'updated_at'])->paginate(100);
        return view('admin.member_role.member_role', compact('member_roles'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());

        MemberRole::create([
            'member_role_name' => $request->member_role_name
        ]);

        return redirect()->back()->with('message', 'Member Role Created Successfully 🙂');


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $member_role = MemberRole::where('id', $id)->first();
        return view('admin.member_role.edit', compact('member_role'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request->all());
        $member_role = MemberRole::where('id', $id)->first();

        $member_role->update([
            'member_role_name' => $request->member_role_name
        ]);

        return redirect()->back()->with('message', 'Member Role Updated Successfully 🙂');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // dd($id);
        $member_role = MemberRole::where('id', $id)->first();
        $member_role->delete();

        return redirect()->back()->with('error', 'Member Role Deleted Successfully');
    }
}
