<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\MailToAllUser;
use App\Jobs\SendMailToAllUsersJob;
use App\Http\Controllers\Controller;

class MailToAllUserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $mails = MailToAllUser::latest('id')->paginate(1000);
        return view('admin.mailtoallusers.mailtoallusers', compact('mails'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        MailToAllUser::create([
            'subject' => $request->subject,
            'message' => $request->message,
        ]);

        // Fetch all users with role_id 4
        $users = User::where('role_id', 4)->get();

        // Dispatch email jobs
        foreach ($users as $user) {
            SendMailToAllUsersJob::dispatch($request->subject, $request->message, $user);
        }

        return redirect()->back()->with('message', 'Message Sent To All Successfully 🙂');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $mails = MailToAllUser::where('id', $id)->first();
        $mails->delete();

        return redirect()->back()->with('message', 'Message Deleted Successfully 🙂');
    }
}
