<?php

namespace App\Http\Controllers\Admin;

use App\Models\Company;
use App\Models\Department;
use App\Models\JobCircular;
use App\Models\ProductType;
use Illuminate\Http\Request;
use App\Models\ReJobCircular;
use App\Models\CompanyDepartment;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\JobCircularStoreRequest;
use App\Http\Requests\JobCircularUpdateRequest;

class JobCircularController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('index-job-circular');

        $jobcirculars = JobCircular::with(['user:id,name', 'department:id,company_department_name', 'company:id,company_name',
        'productType:id,product_name'])
        ->latest('id')
        ->select(['id', 'user_id', 'department_id','company_id', 'producttype_id', 'company_nam', 'job_title', 'company_logo', 'updated_at'])
        ->paginate(1000);

        $departments = CompanyDepartment::select(['id', 'company_department_name'])->get();
        $companies = Company::select(['id', 'company_name'])->get();
        $producttypes = ProductType::select(['id', 'product_name'])->get();

        return view('admin.jobcircular.jobcircular', compact('jobcirculars', 'departments', 'companies', 'producttypes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('index-job-circular');

        $rejobcirculars = ReJobCircular::with(['recruiter:id,name', 'department:id,company_department_name', 'company:id,company_name',
        'productType:id,product_name'])
        ->latest('id')
        ->select(['id', 'recruiter_id', 'department_id','company_id', 'producttype_id', 'company_nam', 'job_title', 'company_logo', 'updated_at'])
        ->paginate(1000);

        return view('admin.jobcircular.rejobcircular', compact('rejobcirculars'));
    }

    public function rejobcircularView($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('index-job-circular');

        $rejobcircular = ReJobCircular::where('id', $id)->first();
        return view('admin.jobcircular.review', compact('rejobcircular'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(JobCircularStoreRequest $request)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('create-job-circular');
        // dd($request->all());

        $imageNameOne = null;
        // Check if a company logo is uploaded
        if ($request->hasFile('company_logo') && $request->file('company_logo')->isValid()) {
            // Generate a unique name for the image
            $imageNameOne = time().'.'.$request->company_logo->extension();
            // Move the uploaded file to a public directory
            $request->company_logo->move(public_path('jobcircular'), $imageNameOne);
        }

        $imageNameTwo = null;
        // Check if a company logo is uploaded
        if ($request->hasFile('job_banner') && $request->file('job_banner')->isValid()) {
            // Generate a unique name for the image
            $imageNameTwo = time().'.'.$request->job_banner->extension();
            // Move the uploaded file to a public directory
            $request->job_banner->move(public_path('jobcircular'), $imageNameTwo);
        }

        // $imageNameOne = time().'.'.$request->company_logo->extension();
        // $request->company_logo->move(public_path('jobcircular'), $imageNameOne);

        // $imageNameTwo = time().'.'.$request->job_banner->extension();
        // $request->job_banner->move(public_path('jobcircular'), $imageNameTwo);

        JobCircular::create([
            'user_id' => Auth::id(),
            'department_id' => $request->department_id,
            'company_id' => $request->company_id,
            'producttype_id' => $request->producttype_id,
            'job_title' => $request->job_title,
            'company_nam' => $request->company_nam,
            'vacancy' => $request->vacancy,
            'responsibilities' => $request->responsibilities,
            'experience' => $request->experience,
            'location' => $request->location,
            'qualification' => $request->qualification,
            'salary_range' => $request->salary_range,
            'others_facilities' => $request->others_facilities,
            'deadline_till' => $request->deadline_till,
            'company_logo' => $imageNameOne,
            'job_banner' => $imageNameTwo,

        ]);
        return redirect()->back()->with('message', 'Job Cicrular Created Successfully 🙂');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('index-job-circular');

        $jobcircular = JobCircular::where('id', $id)->first();
        return view('admin.jobcircular.view', compact('jobcircular'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('edit-job-circular');

        $jobcircular = JobCircular::where('id', $id)->first();
        $departments = CompanyDepartment::select(['id', 'company_department_name'])->get();
        $companies = Company::select(['id', 'company_name'])->get();
        $producttypes = ProductType::select(['id', 'product_name'])->get();

        return view('admin.jobcircular.edit', compact('jobcircular', 'departments', 'companies', 'producttypes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(JobCircularUpdateRequest $request, $id)
    {
        Gate::authorize('edit-job-circular');
        // dd($request->all());

        $jobcircular = JobCircular::findOrFail($id);

        // Update image if a new one is provided
        if ($request->hasFile('company_logo') && $request->file('company_logo')->isValid()) {
            // Delete the old image
            if ($jobcircular->company_logo) {
                unlink('jobcircular/' . $jobcircular->company_logo);
            }
            // Upload new image
            $imageNameOne = time().'.'.$request->company_logo->extension();
            $request->company_logo->move(public_path('jobcircular'), $imageNameOne);
            $jobcircular->company_logo = $imageNameOne;
        }

        // Update image if a new one is provided
        if ($request->hasFile('job_banner') && $request->file('job_banner')->isValid()) {
            // Delete the old image
            if ($jobcircular->job_banner) {
                unlink('jobcircular/' . $jobcircular->job_banner);
            }
            // Upload new image
            $imageNameTwo = time().'.'.$request->job_banner->extension();
            $request->job_banner->move(public_path('jobcircular'), $imageNameTwo);
            $jobcircular->job_banner = $imageNameTwo;
        }

        $jobcircular->update([
            'department_id' => $request->department_id,
            'company_id' => $request->company_id,
            'producttype_id' => $request->producttype_id,
            'job_title' => $request->job_title,
            'company_nam' => $request->company_nam,
            'vacancy' => $request->vacancy,
            'responsibilities' => $request->responsibilities,
            'experience' => $request->experience,
            'location' => $request->location,
            'qualification' => $request->qualification,
            'salary_range' => $request->salary_range,
            'others_facilities' => $request->others_facilities,
            'deadline_till' => $request->deadline_till,
        ]);
        return redirect()->route('jobcircular.index')->with('message', 'Job Circular Updated Successfully 🙂');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Gate::authorize('delete-job-circular');
        $jobcircular = JobCircular::where('id', $id)->first();
        $jobcircular->delete();

        return redirect()->back()->with('warning', 'Job Circular Deleted Successfully');
    }
}
