<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\CompanyDepartment;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use App\Http\Requests\CompanyDepartmentStoreRequest;

class CompanyDepartmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('index-department');

        $departments = CompanyDepartment::latest('id')
        ->select(['id', 'company_department_name', 'is_active', 'updated_at'])->paginate(50);

        return view('admin.company_department.index', compact('departments'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(CompanyDepartmentStoreRequest $request)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('create-department');

        // dd($request->all());
        CompanyDepartment::create([
            'company_department_name' => $request->company_department_name
        ]);
        return redirect()->back()->with('message', 'Department Created Successfully 🙂');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('edit-department');

        $department = CompanyDepartment::where('id', $id)->first();

        return view('admin.company_department.edit', compact('department'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('edit-department');

        // dd($request->all());
        $department = CompanyDepartment::where('id', $id)->first();
        $department->update([
            'company_department_name' => $request->company_department_name,
            'is_active' => $request->filled('is_active'),
        ]);
        return redirect()->route('companydepartment.index')->with('message', 'Department Updated Successfully 🙂');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //authorize this user to access/give access to admin dashboard
        Gate::authorize('delete-department');

        $department = CompanyDepartment::where('id', $id)->first();
        $department->delete();
        return redirect()->back()->with('warning', 'Department Deleted Successfully');
    }
}
