<?php

namespace App\Http\Controllers\Admin;

use App\Models\Apply;
use App\Models\ReApply;
use App\Models\JobCircular;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;

class ApplyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        Gate::authorize('index-job-application');
        $applies = Apply::latest('id')->with('jobCircular', 'user')
        ->select(['id', 'user_id', 'jobcircular_id', 'subject', 'is_active', 'updated_at'])
        ->paginate(1000);

        return view('admin.apply.apply', compact('applies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        Gate::authorize('index-job-application');
        $reapplies = ReApply::latest('id')->with('reJobCircular', 'user')
        ->select(['id', 'user_id', 'rejobcircular_id', 'subject', 'is_active', 'updated_at'])
        ->paginate(1000);

        return view('admin.apply.reapply', compact('reapplies'));
    }

    public function reapplyView($id)
    {
        Gate::authorize('index-job-application');
        $apply = ReApply::where('id', $id)->first();

        // $data = [
        //     'apply' => $apply
        // ];

        // $pdf = Pdf::loadView('admin.apply.review', $data);
        // return $pdf->stream('cv.pdf');

        return view('admin.apply.review', compact('apply'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        Gate::authorize('index-job-application');
        $apply = Apply::where('id', $id)->first();
        return view('admin.apply.view', compact('apply'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        Gate::authorize('edit-job-application');
        $apply = Apply::where('id', $id)->first();
        return view('admin.apply.edit', compact('apply'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        Gate::authorize('edit-job-application');
        // dd($request->all());
        $apply = Apply::where('id', $id)->first();
        $apply->update([
            'is_active' => $request->filled('is_active'),
        ]);

        return redirect()->route('apply.index')->with('message', 'Activated 🙂');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Gate::authorize('delete-job-application');
        $apply = Apply::where('id', $id)->first();
        $apply->delete();

        return redirect()->back()->with('error', 'Successfully Deleted!!');
    }
}
