<?php

namespace App\Http\Controllers\Admin;

use App\Models\About;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class AboutController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $abouts = About::get();
        $about_data = DB::table('abouts')->latest()->first();
        return view('admin.about.about', compact('abouts', 'about_data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $imageNameOne = null;
        // Check if a company logo is uploaded
        if ($request->hasFile('mv_photo') && $request->file('mv_photo')->isValid()) {
            // Generate a unique name for the image
            $imageNameOne = time().'.'.$request->mv_photo->extension();
            // Move the uploaded file to a public directory
            $request->mv_photo->move(public_path('mv_photo'), $imageNameOne);
        }
        $imageNameTwo = null;
        // Check if a company logo is uploaded
        if ($request->hasFile('about_photo') && $request->file('about_photo')->isValid()) {
            // Generate a unique name for the image
            $imageNameTwo = time().'.'.$request->about_photo->extension();
            // Move the uploaded file to a public directory
            $request->about_photo->move(public_path('about_photo'), $imageNameTwo);
        }
        $imageNameThree = null;
        // Check if a company logo is uploaded
        if ($request->hasFile('banner_image') && $request->file('banner_image')->isValid()) {
            // Generate a unique name for the image
            $imageNameThree = time().'.'.$request->banner_image->extension();
            // Move the uploaded file to a public directory
            $request->banner_image->move(public_path('banner_image'), $imageNameThree);
        }
        About::create([
            'title' => $request->title,
            'mission_title' => $request->mission_title,
            'mission_details' => $request->mission_details,
            'vision_title' => $request->vision_title,
            'vision_details' => $request->vision_details,
            'description' => $request->description,
            'mv_photo' => $imageNameOne,
            'about_photo' => $imageNameTwo,
            'banner_image' => $imageNameThree,
        ]);

        return redirect()->back()->with('message', 'Notice Created Successfully 🙂');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $about = About::where('id', $id)->first();
        return view('admin.about.edit_about', compact('about'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request->all());
        $about = About::findOrFail($id);
        // $jobcircular = JobCircular::findOrFail($id);

        // Update image if a new one is provided
        if ($request->hasFile('mv_photo') && $request->file('mv_photo')->isValid()) {
            // Delete the old image
            if ($about->mv_photo) {
                unlink('mv_photo/' . $about->mv_photo);
            }
            // Upload new image
            $imageNameOne = time().'.'.$request->mv_photo->extension();
            $request->mv_photo->move(public_path('mv_photo'), $imageNameOne);
            $about->mv_photo = $imageNameOne;
        }

        if ($request->hasFile('about_photo') && $request->file('about_photo')->isValid()) {
            // Delete the old image
            if ($about->about_photo) {
                unlink('about_photo/' . $about->about_photo);
            }
            // Upload new image
            $imageNameTwo = time().'.'.$request->about_photo->extension();
            $request->about_photo->move(public_path('about_photo'), $imageNameTwo);
            $about->about_photo = $imageNameTwo;
        }

        if ($request->hasFile('banner_image') && $request->file('banner_image')->isValid()) {
            // Delete the old image
            if ($about->banner_image) {
                unlink('banner_image/' . $about->banner_image);
            }
            // Upload new image
            $imageNameThree = time().'.'.$request->banner_image->extension();
            $request->banner_image->move(public_path('banner_image'), $imageNameThree);
            $about->banner_image = $imageNameThree;
        }

        $about->update([
            'title' => $request->title,
            'mission_title' => $request->mission_title,
            'mission_details' => $request->mission_details,
            'vision_title' => $request->vision_title,
            'vision_details' => $request->vision_details,
            'description' => $request->description,
        ]);

        return redirect()->back()->with('message', 'Notice Created Successfully 🙂');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
