<?php

namespace App\Events;

use App\Models\ReJobCircular;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class JobCircularCreated
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $jobCircular;
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(ReJobCircular $jobCircular)
    {
        $this->jobCircular = $jobCircular;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
